﻿using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Socket.Sample1
{
    public partial class FormMain : Form
    {
        [StructLayout(LayoutKind.Sequential)]
        public struct WSAData
        {
            const int WSADescriptionLength = 256;
            const int WSASystemStatusLength = 128;

            public Int16 Version;
            public Int16 HighVersion;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = WSADescriptionLength + 1)]
            public String Description;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = WSASystemStatusLength + 1)]
            public String SystemStatus;
            public Int16 MaxSockets;
            public Int16 MaxUdpDg;
            public IntPtr VendorInfo;
        }

        public const short Success = 0;
        public const short HighVersion = 2;
        public const short LowVesion = 2;
        public const short WordVersion = HighVersion * 256 + LowVesion;

        [DllImport("ws2_32.dll")]
        public static extern Int32 WSAStartup(short wVersionRequested, ref WSAData wsaData);

        [DllImport("ws2_32.dll")]
        public static extern Int32 WSACleanup();

        public FormMain()
        {
            InitializeComponent();
        }

        private void ButtonSettingClick(object sender, EventArgs e)
        {
            WSAData data = new WSAData();

            int result = WSAStartup(WordVersion, ref data);
            if (result != Success) return;
            MessageBox.Show(data.Description);
            WSACleanup();
        }
    }
}